/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.postgresql.pljava.ObjectPool;
import org.postgresql.pljava.PooledObject;
import org.postgresql.pljava.ResultSetProvider;
import org.postgresql.pljava.SessionManager;

public class UsingProperties
implements ResultSetProvider,
PooledObject {
    private static Logger s_logger = Logger.getAnonymousLogger();
    private final Properties m_properties;
    private final ObjectPool m_pool;
    private Iterator m_propertyIterator;

    public UsingProperties(ObjectPool objectPool) throws IOException {
        this.m_pool = objectPool;
        this.m_properties = new Properties();
        s_logger.info("** UsingProperties()");
        InputStream inputStream = this.getClass().getResourceAsStream("example.properties");
        if (inputStream == null) {
            s_logger.info("example.properties was null");
        } else {
            this.m_properties.load(inputStream);
            inputStream.close();
            s_logger.info("example.properties has " + this.m_properties.size() + " entries");
        }
    }

    public void activate() {
        s_logger.info("** UsingProperties.activate()");
        this.m_propertyIterator = this.m_properties.entrySet().iterator();
    }

    public void remove() {
        s_logger.info("** UsingProperties.remove()");
        this.m_properties.clear();
    }

    public void passivate() {
        s_logger.info("** UsingProperties.passivate()");
        this.m_propertyIterator = null;
    }

    public boolean assignRowValues(ResultSet resultSet, int n) throws SQLException {
        if (!this.m_propertyIterator.hasNext()) {
            s_logger.fine("no more rows, returning false");
            return false;
        }
        Map.Entry entry = (Map.Entry)this.m_propertyIterator.next();
        resultSet.updateString(1, (String)entry.getKey());
        resultSet.updateString(2, (String)entry.getValue());
        return true;
    }

    public void close() throws SQLException {
        this.m_pool.passivateInstance((PooledObject)this);
    }

    public static ResultSetProvider getProperties() throws SQLException {
        ObjectPool objectPool = SessionManager.current().getObjectPool(UsingProperties.class);
        return (ResultSetProvider)objectPool.activateInstance();
    }
}

