//
//  PgSQLBindItem.h
//  PostgresSQL
//
//  Created by Pascal on Sat Dec 14 2002.
//  Copyright (c) 2002 P3 Consulting. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef enum	{
	bindItem_Unknown = -1,
	bindItem_Double,
	bindItem_Float,
	bindItem_Short,
	bindItem_Integer,
	bindItem_Long,
	bindItem_LongLong,
	bindItem_CString,
	bindItem_BString,
	bindItem_Text,
	bindItem_BOOL,
	bindItem_Char,
	bindItem_Oid,
	bindItem_Point,
	bindItem_Polygon,
	bindItem_LSeg,
	bindItem_Path,
	bindItem_Line,
	bindItem_Box,
	bindItem_Circle,
	bindItem_INet,
	bindItem_Cidr,
	bindItem_MACAddr,
	bindItem_BIT,
	bindItem_NSDecimal,
	bindItem_NSNumber,
	bindItem_NSString,
	bindItem_NSData,
	bindItem_NSArray
}
	TBindItemType;

@interface PgSQLBindItem : NSObject {
	void *objectAddress	;
	TBindItemType objectType;
}

+(id)newWithAddress:(void *)address type:(TBindItemType)type;
-(id)initWithAddress:(void *)address type:(TBindItemType)type;
-(void *)address;
-(TBindItemType)type;

@end
