/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.polyglot.FunctionProxyNodeGen;
import com.oracle.truffle.polyglot.HostInteropReflect;
import com.oracle.truffle.polyglot.HostToGuestRootNode;
import com.oracle.truffle.polyglot.PolyglotExecuteNode;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Objects;

@ImportStatic(value={HostInteropReflect.class})
abstract class FunctionProxyNode
extends HostToGuestRootNode {
    final Class<?> receiverClass;
    final Method method;

    FunctionProxyNode(Class<?> receiverType, Method method) {
        this.receiverClass = receiverType;
        this.method = method;
    }

    protected Class<? extends TruffleObject> getReceiverType() {
        return this.receiverClass;
    }

    @Override
    public final String getName() {
        return "FunctionalInterfaceProxy<" + this.receiverClass + ", " + this.method + ">";
    }

    @Specialization
    protected Object doCached(PolyglotLanguageContext languageContext, TruffleObject function, Object[] args, @Cached(value="getMethodReturnType(method)") Class<?> returnClass, @Cached(value="getMethodGenericReturnType(method)") Type returnType, @Cached PolyglotExecuteNode executeNode) {
        return executeNode.execute(languageContext, function, args[2], returnClass, returnType);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.receiverClass);
        result = 31 * result + Objects.hashCode(this.method);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FunctionProxyNode)) {
            return false;
        }
        FunctionProxyNode other = (FunctionProxyNode)obj;
        return this.receiverClass == other.receiverClass && this.method.equals(other.method);
    }

    static CallTarget lookup(PolyglotLanguageContext languageContext, Class<?> receiverClass, Method method) {
        FunctionProxyNode node = FunctionProxyNodeGen.create(receiverClass, method);
        CallTarget target = FunctionProxyNode.lookupHostCodeCache(languageContext, node, CallTarget.class);
        if (target == null) {
            target = FunctionProxyNode.installHostCodeCache(languageContext, node, FunctionProxyNode.createTarget(node), CallTarget.class);
        }
        return target;
    }
}

